// Data construction for Panel: Removing planned Cooperations
forvalues y = 2004/2019 {
	use "${data}/source/labex_firm_toremove", clear
		rename firm siren
		keep siren
		gduplicates drop 
		tostring siren, replace format("%09.0f")
	
		merge 1:m siren using  "${tmp}\dads`y'", keep(3) keepusing(nbheur s_brut  catjur catjur_1 apet apen comt comr pcs pcs_1 filt age duree) nogen
		keep if  inlist(filt,1,2)
		destring catjur*, replace
		bys siren (catjur): replace catjur = catjur[1]
		// drop Particuliers employeurs

		keep if (floor(catjur/1000)==5) // keep private
	
		destring siren, replace force
		drop if mi(siren)
	
		replace apet = apen if mi(apet)
		drop apen
	
		if `y'<=2007 {
			ren apet naf_rev1
			merge m:1 siren using "${data}/utils/Siren_NAF_rev12", nogen keep(1 3) keepusing(naf_rev2)
			merge m:1 naf_rev1 using "${data}/utils/NAF_rev12_impute", nogen keep(1 3 4 5) update  keepusing(naf_rev2)
			drop naf_rev1
			ren naf_rev2 apet
		}
		
	
		gen job_eng = (substr(pcs,1,2) == "38")
	
	
	foreach cat in job_eng  {
		*gen `cat'_hc = (`cat' == 1)
		gen `cat'_hrs = nbheur *(`cat' == 1)
		gen `cat'_sbrut = s_brut *(`cat' == 1)
		}
			
		//allocate ZE
		gen depcom = comt
		replace depcom = comr if real(substr(depcom,1,2)) >= 98 | depcom == "69999" | regexm(depcom,"ZZZ")

		replace depcom = "75056" if substr(depcom,1,2) == "75"
		replace depcom = "13055" if inrange(real(depcom),13201,13216)
		replace depcom = "69123" if inrange(real(depcom),69381,69389)
		replace depcom = "59183" if depcom == "59540" | depcom == "59248"
		destring depcom, replace force
		drop if mi(depcom) // drops Corsica
		merge m:1 depcom using "${data}/utils/depcom_ZE_mapping", nogen keep(1 3)

	
		gcollapse (sum) job_eng_sbrut_toremove = job_eng_sbrut, by(ZE2010 apet)
		ren apet ape	
		gen year = `y'
		destring ZE2010, replace force
		if `y' != 2004 {
			append using "${tmp}/R2rdtoremove"
		}
	save "${tmp}/R2rdtoremove", replace
}

// Data construction for Panel: Controlling for Potential Endowment Differences

use "${tmp}/Proximity_naflabex", clear

	merge m:1 labexid using "${data}/utils/labexcom", nogen keep(1 3)

	replace depcom = 75056 if floor(depcom/1000) == 75
	replace depcom = 13055 if inrange(depcom,13201,13216)
	replace depcom = 69123 if inrange(depcom,69381,69389)

	merge m:1 depcom using "${data}/utils/depcom_ZE_mapping", nogen keep(1 3)

	keep labexid ZE2010
	duplicates drop
	drop if ZE == ""
save "${tmp}/ZE_labex", replace
use "${tmp}/main_labex_with_ctrf", clear
	merge 1:1 labexid using "${tmp}/ZE_labex"
	keep if _m == 3
	drop _m
	egen num = sum(dotation)
	egen den = sum(accept)
	gen mdot = num / den
	drop num den
save "${tmp}/main_labex_with_ctrf_geo", replace


forvalues i = 0/1000 {
	qui {
	use "${tmp}/main_labex_with_ctrf_geo", clear
		//139 accepted, 129 refused, let us shuffle
		gen r = runiform()

		gen cluster = 1 if note_total < 27
		replace cluster = 2 if note_total >= 27 & note_total < 30
		replace cluster = 3 if note_total >= 30 & note_total < 33
		replace cluster = 4 if note_total >= 33 
		
		if `i' != 0  {
			bys cluster: egen nb_accept = sum(accept)
			sort cluster r
			replace accept = _n <= nb_accept
		}
		drop r
	save "${tmp}/main_labex_with_ctrf_perm", replace
	
	use "${tmp}/matrix_issn_labex", clear
		joinby issn using "${tmp}/matrix_ape_issn"

		bys ape labex: egen share = sum(share_labex_issn * share_ape_issn)
		keep labex share ape
		duplicates drop
		
		rename share prox

		
		recode prox (missing = 0)
		
		merge m:1 labexid using "${tmp}/main_labex_with_ctrf_perm", nogen keep(3) keepusing(mdot  dotation* note_totale accept ZE2010)
		
		gen exposure_perm = prox*dotation_pred*accept
		gen exposure_perm_l = prox*mdot*accept
		
		gcollapse (sum) exposure_perm exposure_perm_l, by(ZE2010 ape) fast
		destring ZE, replace force
	save "${tmp}/Proximity_naflabex_perm", replace
	rename exposure_perm exposure_perm`i'
	rename exposure_perm_l exposure_perm_l`i'
	if `i' != 0 {
		merge 1:1 ape ZE2010 using "${tmp}/Proximity_naflabex_perm_all", keep(3) nogen
	}
	save "${tmp}/Proximity_naflabex_perm_all", replace
	}
	disp `i'
	}
	use "${tmp}/Proximity_naflabex_perm_all", clear
	
	gen Eperm_mean = 0
	gen Eperm_log = 0
	gen Eperm_log_l = 0
	forvalues i = 1/1000 {
		replace Eperm_mean = Eperm_mean + exposure_perm`i'
		replace Eperm_log = log(1+exposure_perm`i')+Eperm_log
		replace Eperm_log_l = log(1+exposure_perm_l`i')+Eperm_log_l
	}
	
	replace Eperm_mean = Eperm_mean / 1000
	replace Eperm_log = Eperm_log / 1000
	replace Eperm_log_l  = Eperm_log_l / 1000
	
	keep ape ZE Eperm_mean exposure_perm0 Eperm_log  Eperm_log_l
save "${tmp}/BH_tmp", replace
	

	



// Generation of the Table
use "${tmp}/Regfile_nafZE", replace

	
	xtset gp year
		
	destring ZE2010, replace
	
	// define sample 
	egen mlabexid = group(mainlabex)
	qui su mlabexid
	replace mlabexid = r(max) + ZE2010 if mi(mlabexid)
	

	reghdfe ln_eng_sbrut E_post11  if NAF_labex_accept == 1 & ZE_labex_accept == 1 , a(ZE2010#year  gp)  cl(mlabexid)	
	bys gp: egen insampeng = max(e(sample))
	keep if insampeng
	
	drop _merge
	merge 1:1 ape ZE2010 year using "${tmp}/R2rdtoremove", keep(1 3) 
	recode job_eng_sbrut_toremove (missing = 0)

	bys ape ZE2010: egen toremove = max(_m == 3)
	drop _m
	merge m:1 ZE2010 ape using "${tmp}/BH_tmp", keep(1 3) nogen keepusing(Eperm_log)
	replace Eperm_log = 0 if Eperm_log == .
	rename Eperm_log Eperm
	forvalues year = 2004/2019 {
		gen Eperm_`year' = Eperm*(year == `year')
	}
	drop  Eperm_$NORMYEAR
	gen Eperm_post11 = Eperm*(year>=2011)

	global cond_accept = "NAF_labex_accept == 1 & ZE_labex_accept == 1" 

	// Panel Baseline
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ape_n##year ZE2010#year") clust(mlabexid) 
	local row1 = "Baseline & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' &  -  & `=e(Nobs)' obs \\"
	local row2 = "& (`=string(e(se), "%9.4f")') & &  -  & (`=e(Npairs)' pairs) \\ "

	// Panel Removing planned Cooperation
	// Row 1: No firm w/ planned coop.
	gen ln_eng_sbrut_no = log(job_eng_sbrut-job_eng_sbrut_toremove)
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut_no) fe("gp ape_n##year ZE2010#year") clust(mlabexid) 
	local row4 = "1. No firms w/ planned coop. &`=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' &  -  & `=e(Nobs)' obs \\"
	local row5 = "& (`=string(e(se), "%9.4f")') & &  -  & (`=e(Npairs)' pairs) \\ "

	
	// Row 2: No CZxind w/ planned coop.
	replace ln_eng_sbrut_no = log(job_eng_sbrut)
	replace ln_eng_sbrut_no = . if toremove == 1
	
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut_no) fe("gp ape_n##year ZE2010#year") clust(mlabexid) 
	local row6 = "2. No CZ x ind with planned coop. & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' &  -  & `=e(Nobs)' obs \\"
	local row7 = "& (`=string(e(se), "%9.4f")') & &  -  & (`=e(Npairs)' pairs) \\ "
	
	// Panel Contolling for potential endowment differences
	// Row 1: Cabdudates' quality
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ape_n##year ZE2010#year") clust(mlabexid)  control(EP3_2005)
	local row9 = "1. Candidates' quality & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' &  `=string(e(ctrlcoef), "%9.4f")'  & `=e(Nobs)' obs \\"
	local row10 = "& (`=string(e(se), "%9.4f")') & &  (`=string(e(ctrlse), "%9.4f")')  & (`=e(Npairs)' pairs) \\ "	

	// Row 2: Rejected projects	
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ape_n##year ZE2010#year") clust(mlabexid)  control(EP2_2005)
	local row11 = "2. Rejected projects  & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' &  `=string(e(ctrlcoef), "%9.4f")'  & `=e(Nobs)' obs \\"
	local row12 = "& (`=string(e(se), "%9.4f")') & &  (`=string(e(ctrlse), "%9.4f")')  & (`=e(Npairs)' pairs) \\ "	
	
	// Row 3: Funding permutations		
	qui prog_gentable E_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ape_n##year ZE2010#year") clust(mlabexid)  control(Eperm_2005)
	local row13 = "3. Fundings permutations & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' &  `=string(e(ctrlcoef), "%9.4f")'  & `=e(Nobs)' obs \\"
	local row14 = "& (`=string(e(se), "%9.4f")') & &  (`=string(e(ctrlse), "%9.4f")')  & (`=e(Npairs)' pairs) \\ "	
	
	
	local row0 = "& Estimate & Pre-trends test & Control &  Obs \\"
	local row3 = "Removing planned Cooperation \\"
	local row8 = "Contolling for potential endowment differences \\"
	
	file open myfile using "${outpath}/table3.tex", write text replace
	forvalues i = 0/14 {
		file write myfile " `row`i''" _n
	}
	file close myfile
	